---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-Runtime Config Test（StartupHook）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/index.html`（18行）
- E-02: `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/main.js`（24行）
- E-03: `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/Program.cs`（30行）
- E-04: `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/runtimeconfig.template.json`（5行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルは "Runtime config test" | E-01（7行目: `<title>Runtime config test</title>`） | ○ |
| C-02 | ヘッダーは h3 で "Runtime config test" | E-01（15行目: `<h3 id="header">Runtime config test</h3>`） | ○ |
| C-03 | 結果表示に span#out を使用 | E-01（16行目: `<span id="out"></span>`） | ○ |
| C-04 | main.js を module として読み込み | E-01（11行目: `<script type='module' src="./main.js">`） | ○ |
| C-05 | dotnet.js をインポート | E-02（1行目: `import { dotnet } from './_framework/dotnet.js'`） | ○ |
| C-06 | dotnet.create() でランタイム初期化 | E-02（13行目: `await dotnet.create()`） | ○ |
| C-07 | TestMeaning メソッドを呼び出し | E-02（15行目: `const testMeaning = exports.Sample.Test.TestMeaning`） | ○ |
| C-08 | 結果を #out に表示 | E-02（17行目: `document.getElementById("out").innerHTML`） | ○ |
| C-09 | TestMeaning に JSExport 属性 | E-03（17行目: `[JSExport]`） | ○ |
| C-10 | AppContext キーは "Test.StartupHookForFunctionalTest.DidRun" | E-03（19行目: `string appContextKey = "Test.StartupHookForFunctionalTest.DidRun"`） | ○ |
| C-11 | AppContext.GetData で設定値を取得 | E-03（20行目: `AppContext.GetData(appContextKey)`） | ○ |
| C-12 | 設定値 "Yes" と比較 | E-03（22行目: `if (data != "Yes")`） | ○ |
| C-13 | 失敗時は 104 を返却 | E-03（25行目: `return 104`） | ○ |
| C-14 | 成功時は 42 を返却 | E-03（27行目: `return 42`） | ○ |
| C-15 | runtimeconfig.template.json で STARTUP_HOOKS を設定 | E-04（3行目: `"STARTUP_HOOKS": "StartupHookForFunctionalTest"`） | ○ |
| C-16 | 関連機能は Mono, WebAssembly Workload, Hosting | E-06（27行目: 画面No 27 のマッピング） | ○ |

## 4) 不足情報（Unknown / Missing）

すべての主張に対して根拠が確認できました。不足情報はありません。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に根拠があり、ソースコードと整合しています

## 6) レビュアーチェックリスト（最小）

- [ ] index.html、main.js、Program.cs のコード内容が設計書の記述と一致しているか確認
- [ ] runtimeconfig.template.json の STARTUP_HOOKS 設定が正しく反映されるか確認
- [ ] スタートアップフックが正しく実行され、AppContext に値が設定されるか確認
- [ ] AppContext.GetData() でスタートアップフックが設定した値を正しく取得できるか確認
